import React, {Component} from 'react';
import Select from "../Select/Select";
import {graphql, compose} from "react-apollo";
import { speciesProgettoQuery, stadioSviluppoQuery } from '../../../../api/queries'
import {Card, CardBody, CardText} from "reactstrap";
import BlinkDot from "../../../Loading/BlinkDot";

class SpeciesSelect extends Component {

  constructor(props) {
    super(props);
  }

  componentDidMount () {
    this.props.data.refetch()
  }

  render() {
    if(this.props.data.loading) {
      return(<Card>
        <CardBody>
          <CardText className="text-info">
            Caricamento in corso{' '}
            <BlinkDot/>
            <BlinkDot/>
            <BlinkDot/>
          </CardText>
        </CardBody>
      </Card>);
    }

    return (
      <Select
        {...this.props}
        options={[
          {label: "Seleziona un\'opzione", value: ''},
          ...this.props.data.specieProgettos.map((option) => ({
            label: option.specie.denominazioneTaxon,
            value: option.id
          }))
        ]}
      />
    )
  }
}

export default compose(
  graphql(speciesProgettoQuery),
)(SpeciesSelect)

SpeciesSelect.defaultProps = {};

SpeciesSelect.propTypes = {};
